(define/contract (beautiful-bouquet flowers k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length flowers))
  (define mod 1000000007)
  (define count (make-hash))
  (define left 0)
  (define result 0)

  (for ([right (in-range n)])
    (hash-update! count (list-ref flowers right) add1 0)
    (while (> (hash-count count) k)
      (hash-update! count (list-ref flowers left) sub1)
      (when (zero? (hash-ref count (list-ref flowers left)))
        (hash-remove! count (list-ref flowers left)))
      (set! left (add1 left)))
    (set! result (modulo (+ result (- right left 1)) mod)))
  result)